package dtelements;

import java.util.ArrayList;
import java.util.LinkedList;



public class DecisionTree {

	private Node root;
	private String[] classLabels;

	public DecisionTree(Node root, String[] classLabels) {
		this.root = root;
		this.classLabels = classLabels;
	}

	public void setRoot(Node root) {
		this.root = root;
	}

	public Node getRoot() {
		return root;
	}

	public void Report(Node node) {

		System.out.print("Root\t");
		System.out.println("{" + node.getAttribute().getName() + "}");
		ReportRecursive(node);
	}
	
	public boolean determineClass(ArrayList<Attribute> attributes, ArrayList<String> attributeValues)
	{
		boolean determined = false;
		
		Node node = this.root;
		while(!determined)
		{
			int valueIndex = attributes.indexOf(node.getAttribute());
			
			
			String attributeValue = attributeValues.get(valueIndex);
			
			if(node.isLeaf())
			{
				return node.getPluralityValue(attributeValue);
			}
			else
			{
				int edgeIndex = node.getEdgeLabels().indexOf(attributeValue);
				
				if(edgeIndex < 0)
				{
					return node.getPluralityValue(attributeValue);
				}
				else
				{
					node = node.getEdges().get(edgeIndex);
				}
			}
		}
		
		return false;
	}
	

	public ArrayList<Node> getAllInternalNodes()
	{
		ArrayList<Node> allNodes = new ArrayList<Node>();
		LinkedList<Node> queue = new LinkedList<Node>();
		
		if(!this.root.isLeaf())
		{
			queue.addFirst(this.root);
		}
		
		while(queue.size() > 0)
		{
			Node node = queue.getFirst();
			queue.removeFirst();
			allNodes.add(0, node);
			
			for(Node n : node.getEdges())
			{
				if(!n.isLeaf())
					queue.addFirst(n);
			}
		}
		
		return allNodes;
	}
	public ArrayList<Node> getAllNodes()
	{
		ArrayList<Node> allNodes = new ArrayList<Node>();
		LinkedList<Node> queue = new LinkedList<Node>();
		
		queue.addFirst(this.root);
		allNodes.add(0, this.root);
		
		while(queue.size() > 0)
		{
			Node node = queue.getFirst();
			queue.removeFirst();
			allNodes.add(0, node);
			
			for(Node n : node.getEdges())
			{
				queue.addFirst(n);
			}
		}
		
		return allNodes;
	}
	private void ReportRecursive(Node node)
	{
		for(String attributeValue : node.getAttribute().getDomain())
		{
			int index =node.getEdgeLabels().indexOf(attributeValue); 
			if(index < 0)
			{
				System.out.print(tabs(node.getDepth()));
				System.out.print(attributeValue + "\t(");
				if(node.getPluralityValue(attributeValue))
				{
					System.out.println(this.classLabels[1] + ")");
				}
				else
				{
					System.out.println(this.classLabels[0] + ")");
				}
			}
			else
			{
				System.out.print(tabs(node.getDepth()));
				System.out.println(attributeValue + "\t" + "{" + node.getEdges().get(index).getAttribute().getName() + "}");
				ReportRecursive(node.getEdges().get(index));
			}
		}
	}
	
	private String tabs(int n)
	{
		String ret = "";
		for(int i = 0; i <= n; i++)
			ret += "\t";
		return ret;
	}

}
